package com.ejie.ab04b.dao.custom;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.TramiteAperturasDao;
import com.ejie.ab04b.model.ComunicacionApertura;
import com.ejie.ab04b.model.TramiteAperturas;
import com.ejie.x38.dto.JQGridRequestDto;

/**
 * TramiteAperturasDao generated by UDA, 02-Feb-2017 13:49:16.
 * 
 * @author UDA
 */

public interface TramiteAperturasCustomDao extends TramiteAperturasDao {

	/**
	 * Finds a single row in the TramiteAperturas table.
	 * 
	 *  tramiteAperturas
	 *            TramiteAperturas
	 *  TramiteAperturas
	 *
	 * @param tramiteAperturas the tramite aperturas
	 * @return the tramite aperturas
	 */
	@Transactional(readOnly = true)
	public TramiteAperturas vfind(TramiteAperturas tramiteAperturas);

	/**
	 * Finds a single row in the TramiteAperturas table.
	 * 
	 *  idTipoTramite
	 *            Long
	 *  apertura
	 *            ComunicacionApertura
	 *  TramiteAperturas
	 *
	 * @param idTipoTramite the id tipo tramite
	 * @param apertura the apertura
	 * @return the tramite aperturas
	 */
	@Transactional(readOnly = true)
	public TramiteAperturas findLastTramiteByTipo(Long idTipoTramite,
			ComunicacionApertura apertura);

	/**
	 * Finds a list of rows in the TramiteAperturas table.
	 * 
	 *  tramiteAperturas
	 *            TramiteAperturas
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<TramiteAperturas>
	 *
	 * @param tramiteAperturas the tramite aperturas
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<TramiteAperturas> vfindAll(TramiteAperturas tramiteAperturas,
			JQGridRequestDto jqGridRequestDto);

	/**
	 * Finds a list of rows in the TramiteAperturas table.
	 * 
	 *  filterTramiteAperturas
	 *            TramiteAperturas
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  b
	 *            boolean
	 *  List<TramiteAperturas>
	 *
	 * @param filterTramiteAperturas the filter tramite aperturas
	 * @param jqGridRequestDto the jq grid request dto
	 * @param b the b
	 * @return the list
	 */
	public List<TramiteAperturas> findAllImprimirDocsAperturaLike(
			TramiteAperturas filterTramiteAperturas,
			JQGridRequestDto jqGridRequestDto, boolean b);

	/**
	 * Finds a list of rows in the TramiteAperturas table.
	 * 
	 *  tramiteAperturas
	 *            TramiteAperturas
	 *  b
	 *            boolean
	 *  Long
	 *
	 * @param tramiteAperturas the tramite aperturas
	 * @param b the b
	 * @return the long
	 */
	public Long findAllLikeImprimirDocsAperturaCount(
			TramiteAperturas tramiteAperturas, boolean b);

}
